# Aşama 3: FilamentPHP v3 Yönetim Paneli

## Kurulum Adımları

### 1. FilamentPHP Kur

```bash
composer require filament/filament:"^3.0"
php artisan filament:install --panels
php artisan migrate
```

### 2. Dili Türkçe Yap

`config/app.php`:
```php
'locale'       => 'tr',
'faker_locale' => 'tr_TR',
```

Topluluk Türkçe paketi (önerilir):
```bash
composer require lara-zeus/translatable
# veya
php artisan vendor:publish --tag=filament-translations
```

### 3. Admin Kullanıcı Oluştur

```bash
php artisan make:filament-user
# veya
php artisan tinker
>>> \App\Models\User::factory()->create(['email'=>'admin@example.com','password'=>bcrypt('password'),'name'=>'Admin'])
```

### 4. Provider'ı Kaydet

`bootstrap/providers.php`:
```php
App\Providers\Filament\AdminPanelProvider::class,
```

### 5. Panel'e Eriş

`https://your-domain.com/admin`

---

## Dosya Yapısı (Aşama 3)

```
app/
├── Filament/
│   ├── Resources/
│   │   └── LicenseResource.php              ← Ana CRUD kaynağı
│   │   └── LicenseResource/
│   │       └── Pages/
│   │           ├── ListLicenses.php
│   │           ├── CreateLicense.php         ← secret_token bildirimi
│   │           └── EditLicense.php
│   └── Widgets/
│       ├── StatsOverviewWidget.php           ← İstatistik kartları
│       ├── LicenseChartWidget.php            ← Aktivasyon trend grafiği
│       └── RecentActivationsWidget.php       ← Son 24s aktivasyonlar
│
├── Providers/
│   └── Filament/
│       └── AdminPanelProvider.php            ← Panel konfigürasyonu

resources/views/filament/
└── license-inspect-modal.blade.php           ← Sorgula modal içeriği

lang/tr/
└── filament.php                              ← Türkçe çeviriler
```

---

## Dashboard Widget'ları

| Widget | Açıklama | Yenileme |
|--------|----------|----------|
| `StatsOverviewWidget` | Toplam, Aktif, Kritik, Son24s, Askıya | 30s |
| `LicenseChartWidget` | 7/30/90 günlük aktivasyon trend çizgi grafiği | Manuel |
| `RecentActivationsWidget` | Son 24s giriş/hata log tablosu | 60s |

---

## Tablo Aksiyonları

### 💬 Mesaj Gönder
- Modal açar → `admin_message` textarea
- Kaydedince WP eklentisi bir sonraki `verify` isteğinde mesajı alır
- Filament Notification ile başarı bildirimi

### 🚫 Lisansı İptal Et (Kill-Switch)
- Onay modalı zorunlu
- `status = suspended` yapar
- Kırmızı badge ile tabloda görünür
- Müşteri bir sonraki doğrulamada 403 alır

### ✅ Aktive Et
- Sadece `suspended` kayıtlarda görünür
- `status = active` yapar

### 🔍 Manuel Sorgula
- Son başarılı verify/activation log kaydını gösterir
- IP adresi, domain, user-agent, zaman bilgileri
- Aktif admin mesajı varsa amber uyarı kutusu

---

## Form Özellikleri

### Otomatik Anahtar Üretimi
```php
TextInput::make('license_key')
    ->default(fn () => $generator->generate())
    ->suffixAction(
        Action::make('generate')
            ->action(fn (Set $set) => $set('license_key', $generator->generateUnique()))
    )
```
"Yeni Üret" butonu tıklandığında canlı olarak yeni kriptografik anahtar üretir.

### Sınırsız Lisans Toggle
```php
Toggle::make('is_unlimited')->live()
DateTimePicker::make('valid_until')
    ->hidden(fn (Get $get) => (bool) $get('is_unlimited'))
```
Toggle `true` → DatePicker gizlenir, `valid_until = null` kaydedilir.

### Durum Rozetleri
| Durum | Renk | İkon |
|-------|------|------|
| Aktif | 🟢 Yeşil (success) | check-circle |
| Askıya Alındı | 🔴 Kırmızı (danger) | no-symbol |
| Süresi Doldu | 🟠 Turuncu (warning) | clock |

### Navigasyon Badge
```php
public static function getNavigationBadgeColor(): ?string
{
    return 'danger'; // Kırmızı rakam
}
```
Kritik lisans sayısı (süresi dolmuş + 7 günde bitecek) sol menüde kırmızı rozet olarak görünür.
