<?php

namespace App\Filament\Resources\LicenseResource\Pages;

use App\Filament\Resources\LicenseResource;
use App\Services\LicenseKeyGenerator;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Database\Eloquent\Model;

class CreateLicense extends CreateRecord
{
    protected static string $resource = LicenseResource::class;

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    /**
     * Kayıt oluşturulmadan önce secret_token ekle.
     */
    protected function mutateFormDataBeforeCreate(array $data): array
    {
        /** @var LicenseKeyGenerator $generator */
        $generator = app(LicenseKeyGenerator::class);

        $data['secret_token'] = $generator->generateSecretToken();

        // is_unlimited formu temizle (DB sütunu yok)
        if (!empty($data['is_unlimited'])) {
            $data['valid_until'] = null;
        }
        unset($data['is_unlimited']);

        return $data;
    }

    protected function afterCreate(): void
    {
        $secretToken = $this->record->getRawOriginal('secret_token');

        // Secret token'ı tek seferlik bildirim olarak göster
        Notification::make()
            ->title('Lisans oluşturuldu! 🎉')
            ->body(
                "Secret Token (bir kez görünür):\n\n" .
                "<code style='font-family:monospace;font-size:11px;word-break:break-all;'>{$secretToken}</code>\n\n" .
                "Bu token'ı güvenli bir yerde saklayın. Tekrar gösterilmeyecektir."
            )
            ->success()
            ->persistent()
            ->send();
    }
}
