<?php

namespace App\Filament\Widgets;

use App\Models\LicenseActivationLog;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Database\Eloquent\Builder;

class RecentActivationsWidget extends BaseWidget
{
    protected static ?string $heading = 'Son Aktivasyonlar (24 Saat)';
    protected static ?int    $sort    = 3;
    protected int | string | array $columnSpan = 'full';
    protected static ?string $pollingInterval = '60s';

    public function table(Table $table): Table
    {
        return $table
            ->query(
                LicenseActivationLog::query()
                    ->with('license')
                    ->whereIn('action', ['activated', 'failed'])
                    ->where('created_at', '>=', now()->subHours(24))
                    ->latest('created_at')
                    ->limit(20)
            )
            ->columns([
                Tables\Columns\TextColumn::make('created_at')
                    ->label('Zaman')
                    ->dateTime('d.m.Y H:i:s')
                    ->sortable()
                    ->timezone('Europe/Istanbul'),

                Tables\Columns\TextColumn::make('license.license_key')
                    ->label('Lisans Anahtarı')
                    ->fontFamily('mono')
                    ->searchable()
                    ->copyable()
                    ->copyMessage('Kopyalandı!')
                    ->weight('medium'),

                Tables\Columns\TextColumn::make('domain')
                    ->label('Domain')
                    ->icon('heroicon-m-globe-alt')
                    ->placeholder('—'),

                Tables\Columns\TextColumn::make('ip_address')
                    ->label('IP Adresi')
                    ->fontFamily('mono')
                    ->placeholder('—'),

                Tables\Columns\BadgeColumn::make('action')
                    ->label('İşlem')
                    ->formatStateUsing(fn (string $state) => match ($state) {
                        'activated'   => 'Aktive Edildi',
                        'verified'    => 'Doğrulandı',
                        'deactivated' => 'Deaktive Edildi',
                        'failed'      => 'Başarısız',
                        default       => $state,
                    })
                    ->color(fn (string $state) => match ($state) {
                        'activated'   => 'success',
                        'verified'    => 'info',
                        'deactivated' => 'warning',
                        'failed'      => 'danger',
                        default       => 'gray',
                    }),

                Tables\Columns\TextColumn::make('note')
                    ->label('Not')
                    ->placeholder('—')
                    ->wrap()
                    ->limit(60),
            ])
            ->defaultSort('created_at', 'desc')
            ->striped()
            ->paginated(false);
    }
}
