<?php

namespace Database\Factories;

use App\Models\License;
use App\Services\LicenseKeyGenerator;
use Illuminate\Database\Eloquent\Factories\Factory;

class LicenseFactory extends Factory
{
    protected $model = License::class;

    public function definition(): array
    {
        $generator = new LicenseKeyGenerator();

        return [
            'license_key'         => $generator->generate(),
            'secret_token'        => $generator->generateSecretToken(),
            'customer_name'       => $this->faker->name(),
            'customer_email'      => $this->faker->unique()->safeEmail(),
            'domain'              => null,
            'status'              => 'active',
            'activation_limit'    => $this->faker->numberBetween(1, 5),
            'current_activations' => 0,
            'valid_until'         => $this->faker->optional(0.7)->dateTimeBetween('+1 month', '+2 years'),
            'admin_message'       => null,
            'last_verify_at'      => null,
        ];
    }

    public function active(): static
    {
        return $this->state(['status' => 'active']);
    }

    public function suspended(): static
    {
        return $this->state(['status' => 'suspended']);
    }

    public function expired(): static
    {
        return $this->state([
            'status'    => 'expired',
            'valid_until' => now()->subDays(rand(1, 30)),
        ]);
    }

    public function unlimited(): static
    {
        return $this->state(['valid_until' => null]);
    }
}
