<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Aktivasyon / deaktivasyon geçmişini tutan audit tablosu.
 * Her domain hareketi burada kayıt altına alınır.
 */
return new class extends Migration
{
    public function up(): void
    {
        Schema::create('license_activation_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('license_id')
                  ->constrained('licenses')
                  ->cascadeOnDelete();

            $table->enum('action', ['activated', 'verified', 'deactivated', 'failed'])
                  ->index();

            $table->string('domain', 255)->nullable();
            $table->string('ip_address', 45)->nullable()->comment('IPv4 veya IPv6');
            $table->string('user_agent', 512)->nullable();
            $table->text('note')->nullable()->comment('Hata mesajı veya ek bilgi');

            $table->timestamp('created_at')->useCurrent()->index();

            // Lisans bazlı sorgu için composite index
            $table->index(['license_id', 'action', 'created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('license_activation_logs');
    }
};
