<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // İlk admin kullanıcısını oluştur
        User::firstOrCreate(
            ['email' => 'admin@lms.local'],
            [
                'name'     => 'LMS Admin',
                'email'    => 'admin@lms.local',
                'password' => Hash::make('password'),
            ]
        );

        $this->command->info('✅ Admin kullanıcı oluşturuldu: admin@lms.local / password');
    }
}
