<?php

use App\Http\Controllers\Api\V1\LicenseController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes — v1
|--------------------------------------------------------------------------
|
| Tüm /api/v1/license/* endpoint'leri VerifyHmacSignature middleware'i
| tarafından korunur. Her istek X-License-Key, X-Signature,
| X-Timestamp ve X-Nonce header'larını taşımalıdır.
|
*/

Route::prefix('v1')->group(function () {

    // ── HMAC Korumalı: WordPress Eklentisi Endpoint'leri ──────────────────────
    Route::middleware('hmac')->prefix('license')->group(function () {

        // İlk aktivasyon — domain kilitleme + secret_token döner
        Route::post('activate',   [LicenseController::class, 'activate'])
             ->name('license.activate');

        // Rutin doğrulama — günlük cron'dan çağrılır
        Route::post('verify',     [LicenseController::class, 'verify'])
             ->name('license.verify');

        // Deaktivasyon — eklenti kaldırma / lisans taşıma
        Route::post('deactivate', [LicenseController::class, 'deactivate'])
             ->name('license.deactivate');
    });

    // ── Admin Endpoint'leri (Sanctum ile korunur) ──────────────────────────────
    Route::middleware('auth:sanctum')->prefix('admin/licenses')->group(function () {
        Route::post('/',        [LicenseController::class, 'store'])->name('admin.license.store');
        Route::get('/{key}',   [LicenseController::class, 'show'])->name('admin.license.show');
    });
});
