<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule;
use App\Models\License;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

// ─── Zamanlanmış Görevler ───────────────────────────────────────────────────

// Süresi dolmuş lisansları her gece güncelle
Schedule::call(function () {
    License::where('status', 'active')
        ->whereNotNull('valid_until')
        ->where('valid_until', '<=', now())
        ->update(['status' => 'expired']);
})->daily()->name('mark-expired-licenses');

// Eski aktivasyon loglarını temizle (90 günden eski)
Schedule::call(function () {
    \App\Models\LicenseActivationLog::where('created_at', '<', now()->subDays(90))->delete();
})->weekly()->name('cleanup-old-logs');
