<?php
/**
 * Plugin Name:       Verdent — [Eklenti Adı]
 * Plugin URI:        https://your-domain.com
 * Description:       [Eklenti açıklaması]
 * Version:           3.0.0
 * Requires at least: 6.0
 * Requires PHP:      8.0
 * Author:            [Yazar]
 * License:           Proprietary
 * Text Domain:       verdent
 */

declare(strict_types=1);

if (!defined('ABSPATH')) {
    exit;
}

// ─── Eklenti Sabitleri ────────────────────────────────────────────────────────

/** Laravel LMS API sunucusu */
define('VRD_API_URL', 'https://your-lms-server.com');

/** Bu eklentinin kök dizini */
define('VRD_PLUGIN_DIR', plugin_dir_path(__FILE__));

// ─── Sınıf Yükleme ────────────────────────────────────────────────────────────

require_once VRD_PLUGIN_DIR . 'includes/class-verdent-license-protector.php';

// ─── Eklenti Yaşam Döngüsü ────────────────────────────────────────────────────

/**
 * Eklenti etkinleştirme kancası.
 * Lisansı aktive et ve cron'u planla.
 */
register_activation_hook(__FILE__, function (): void {
    $license_key = get_option('vrd_lk', '');
    if (empty($license_key)) {
        // Henüz lisans girilmemişse aktivasyon sayfasına yönlendir
        add_option('_vrd_activation_redirect', true, '', 'no');
        return;
    }

    $protector = Verdent_License_Protector::ignite(VRD_API_URL, $license_key);
    $protector->activate_license();
});

/**
 * Eklenti devre dışı bırakma kancası.
 * Lisansı deaktive et ve cron'u temizle.
 */
register_deactivation_hook(__FILE__, function (): void {
    $license_key = get_option('vrd_lk', '');
    if (empty($license_key)) {
        return;
    }

    $protector = Verdent_License_Protector::ignite(VRD_API_URL, $license_key);
    $protector->deactivate_license();
});

/**
 * Ana başlatma — `plugins_loaded` en güvenli başlangıç noktasıdır.
 * Bu noktada WordPress tam yüklenmiş, diğer eklentiler hazır.
 */
add_action('plugins_loaded', function (): void {
    $license_key = get_option('vrd_lk', '');

    // Lisans anahtarı girilmemişse sadece ayarlar sayfasını aktif et
    if (empty($license_key)) {
        add_action('admin_menu', function (): void {
            add_options_page(
                'Verdent Lisans', 'Verdent Lisans', 'manage_options',
                'vrd-license',
                function (): void {
                    echo '<div class="wrap"><h1>Verdent Lisans</h1>'
                        . '<p>Lütfen lisans anahtarınızı girin.</p>'
                        . '<form method="post" action="' . esc_url(admin_url('admin-post.php')) . '">'
                        . '<input type="hidden" name="action" value="vrd_save_license">'
                        . wp_nonce_field('vrd_license_nonce', '_vrd_n', true, false)
                        . '<input type="text" name="vrd_lk" class="regular-text code" placeholder="XXXX-XXXX-XXXX-XXXX">'
                        . get_submit_button('Aktive Et')
                        . '</form></div>';
                }
            );
            add_action('admin_post_vrd_save_license', function (): void {
                check_admin_referer('vrd_license_nonce', '_vrd_n');
                $key = sanitize_text_field($_POST['vrd_lk'] ?? '');
                if ($key) {
                    update_option('vrd_lk', $key, 'no');
                    $p = Verdent_License_Protector::ignite(VRD_API_URL, $key);
                    $p->activate_license();
                }
                wp_safe_redirect(admin_url('options-general.php?page=vrd-license'));
                exit;
            });
        });
        return;
    }

    // ─── Lisans korumalı başlatma ──────────────────────────────────────────────
    Verdent_License_Protector::ignite(VRD_API_URL, $license_key)->mount();

    // İlk etkinleştirmeden sonra aktivasyon sayfasına yönlendir
    if (get_option('_vrd_activation_redirect')) {
        delete_option('_vrd_activation_redirect');
        add_action('admin_init', function (): void {
            wp_safe_redirect(admin_url('options-general.php?page=vrd-license'));
            exit;
        });
    }
});
